/*----------------------------------------------------------------------------
 * Name:    button.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include	"button.h"

u8 ButtonDebounceTime;
u8 ButtonRepeatTime;
u8 ButtonCurrentStatus;
u8 ButtonPreviousStatus;

/*****************************************************************************************************
* @brief  Configures BUTTON I/O
* @retval None
*******************************************************************************************************/
void button_IO_configure(void)																																
{
	/* configure BUTTON as GPIO  */   
	AFIO_GPxConfig(BTN1_PORT_NUM,(1UL << _BUTTON1_),AFIO_FUN_DEFAULT); 															
	AFIO_GPxConfig(BTN2_PORT_NUM,(1UL << _BUTTON2_),AFIO_FUN_DEFAULT); 
	AFIO_GPxConfig(BTN3_PORT_NUM,(1UL << _BUTTON3_),AFIO_FUN_DEFAULT); 
	AFIO_GPxConfig(BTN4_PORT_NUM,(1UL << _BUTTON4_),AFIO_FUN_DEFAULT);
	
	/* configure BUTTON as IN mode  */
	GPIO_DirectionConfig(BUTTON1_PORT,(1UL << _BUTTON1_),GPIO_DIR_IN);
	GPIO_DirectionConfig(BUTTON2_PORT,(1UL << _BUTTON2_),GPIO_DIR_IN);
	GPIO_DirectionConfig(BUTTON3_PORT,(1UL << _BUTTON3_),GPIO_DIR_IN);	
	GPIO_DirectionConfig(BUTTON4_PORT,(1UL << _BUTTON4_),GPIO_DIR_IN);
	
	/* configure BUTTON input enable */   
	GPIO_InputConfig(BUTTON1_PORT,(1UL << _BUTTON1_),ENABLE); 
	GPIO_InputConfig(BUTTON2_PORT,(1UL << _BUTTON2_),ENABLE);   
	GPIO_InputConfig(BUTTON3_PORT,(1UL << _BUTTON3_),ENABLE);  
	GPIO_InputConfig(BUTTON4_PORT,(1UL << _BUTTON4_),ENABLE);  	
	
	/* configure BUTTON pull-up function enabled  */
	GPIO_PullResistorConfig(BUTTON1_PORT,(1UL << _BUTTON1_),GPIO_PR_UP);
	GPIO_PullResistorConfig(BUTTON2_PORT,(1UL << _BUTTON2_),GPIO_PR_UP);
	GPIO_PullResistorConfig(BUTTON3_PORT,(1UL << _BUTTON3_),GPIO_PR_UP);
	GPIO_PullResistorConfig(BUTTON4_PORT,(1UL << _BUTTON4_),GPIO_PR_UP);
	
	ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
	ButtonCurrentStatus = 0;
	ButtonPreviousStatus = 0;
}
/*****************************************************************************************************
* @brief  scan BUTTON I/O status
* @retval None
*******************************************************************************************************/
bool scan_button_IO(void)																																	
{
	u8 bts;

	bts  = load_button_IO();
  if(bts ^ ButtonCurrentStatus)
  {
     ButtonCurrentStatus = bts;
     ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
     ButtonRepeatTime = BUTTON_REPEAT1_DURATION;
  }
	else
	{
		if(bts == 0)
		{
			ButtonPreviousStatus = ButtonCurrentStatus;
			return(FALSE);
		}
		if(--ButtonDebounceTime == 0)
		{
			ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
			if(ButtonCurrentStatus ^ ButtonPreviousStatus)
			{
				ButtonPreviousStatus = ButtonCurrentStatus;
				ButtonRepeatTime--;
				return(TRUE);
			}
			else
			{
				if(--ButtonRepeatTime == 0)
				{
					ButtonRepeatTime = BUTTON_REPEAT2_DURATION;
					return(TRUE);               
				}
			}
		}
	}
	return(FALSE);	
}
/*****************************************************************************************************
* @brief  load BUTTON IO state
* @retval BUTTON status
*******************************************************************************************************/
u8 load_button_IO(void)																															
{
	u8 bts = 0;

	bts |= BUTTON1_IN ? 0x00:0x01;
	bts |= BUTTON2_IN ? 0x00:0x02;
	bts |= BUTTON3_IN ? 0x00:0x04;
	bts |= BUTTON4_IN ? 0x00:0x08;
	
	return(bts);
}
/*****************************************************************************************************
* @brief  get BUTTON status
* @retval BUTTON status
*******************************************************************************************************/
u8 get_button_status(void)
{
	return(ButtonPreviousStatus);
}
